﻿
var ini = cFos_object.ini_file;
// these objects must be persistant across function calls, otherwise the underlying enumerations/arrays will be deleted
var ras_entry = cFos_object.ras_entry;
var netcard_entry = cFos_object.netcard_entry;

function spd(cmd) {
   return cFos_object.spd_command("@" + cmd);
}

function get_val(name) {
   var s = spd("set " + name);
   var m = s.match(/= *(.*)/);
   if (m == null) return "";
   s = jQuery.trim(m[1]);
   if (s == "inf") return "0";
   return String(parseInt(s / 1000));
}

function set_val(name, val) {
   if (val == 0) val = "inf";
   else val *= 1000;
   spd("set " + name + " " + val);
}

function get_limits() {
   $("#rx_limit")[0].value = get_val("rx_limit");
   $("#tx_limit")[0].value = get_val("tx_limit");
   $("#max_rx").text(get_val("maxrx"));
   $("#max_tx").text(get_val("maxtxraw"));
}

function set_limits() {
   set_val("rx_limit", $("#rx_limit")[0].value);
   set_val("tx_limit", $("#tx_limit")[0].value);
   get_limits();
}

var old_server_pwd = null;

function get_server_pwd() {
   var s = cFos_object.param("server_password");
   $("#server_pwd")[0].value = s;
   old_server_pwd = s;
   if (s == "") {
      $("#no_server_pwd").show();
      $("#has_server_pwd").hide();
   }
   else {
      $("#no_server_pwd").hide();
      $("#has_server_pwd").show();
   }
}

function set_server_pwd() {
   var s = $("#server_pwd")[0].value;
   if (s != "" && s != old_server_pwd) s = "!" + s;
   cFos_object.param("server_password") = s;
   get_server_pwd();
}

function browse_for_file() {
   var f = cFos_object.open_file_dialog("*.txt\0*.txt\0*.*\0*.*\0", 0);
   if (f != "") $("#blocklist")[0].value = f;
   ini.open("user.ini", "iplist");
   var old = ini.value("ipfilter");
   if (old != f) {
      ini.value("ipfilter") = f;
      ini.flush();
      spd("reload -iplist");
   }
}

function delete_ip_list() {
   $("#blocklist").value = "";
   ini.open("user.ini", "iplist");
   var old = ini.value("ipfilter");
   ini.value("ipfilter") = "";
   ini.flush();
   spd("reload -iplist");
}

var checkboxes = {
   expand_rwin: { on: 1, off: 0 }, latency: { on: 1, off: 2 }, avoid_loss: { on: 1, off: 0 },
   handle_mss: { on: 1, off: 0 }, strict_rtp_check: { on: 1, off: 0 }, firewall: { on: 1, off: 0 },
   fg_detect: { on: 1, off: 0 }
};

var adapters = [ ];

function load_adapters() {
   // status: 1 = ts enabled, 2 = ts disabled
   var a = ras_entry;
   var i, len = a.length;
   for (i=0; i < len; ++i) adapters.push({ ras: true, name: a.name(i), idx: i, router: ""});
   a = netcard_entry;
   len = a.length;
   for (i=0; i < len; ++i) adapters.push({ ras: false, name: a.name(i), idx: i, router: a.router_info(i)});
   adapters.sort(function(l, r) {
      if (l.router < r.router) return 1;
      if (l.router > r.router) return -1;
      return 0;
   });
   var s = "";
   for (i=0; i < adapters.length; ++i) {
      var r = adapters[i].router ? '<br/><span class="xxxsmall">' + adapters[i].router + '</span>' : "";
      s += '<tr><td>' + adapters[i].name + r + '</td>'
         + '<td style="padding-left: 12px"><img class="button" src="images/settings.png" onmouseover=\'this.src="images/settings_a.png";\' onmouseout=\'this.src="images/settings.png";\' alt="' + ml_object.settings + '" title="' + ml_object.settings + '" onclick="show_ts_settings(' + i + ')"/></td></tr>';
   }
   $("#con_list").append(s);
}

function checked(e) {
   return e.src.indexOf("checkbox_on") != -1;
}

// default: no ts, no budget, no medium
// current: no ts, spd set budget 0 (off) 1-10, spd set medium

function show_ts_settings(n) {
   var d = $("#con_settings div div.setting").show();
   d.find("img").attr("src", "images/checkbox_off.png");
   var o = null;
   if (n >= 0) o = adapters[n].ras ? ras_entry : netcard_entry;
   if (n < 0) $("#allow_ts").parent().hide();
   else if (o.status(adapters[n].idx) != 1) $("#allow_ts").attr("src", "images/checkbox_on.png");

   if (n == -2) {
      $("#budget").parent().hide();
      $("#medium").parent().hide();
   }
   else {
      var v = n == -1 ? spd("set budget").match(/=\s*(\d+)\s*$/)[1] : o.budget(adapters[n].idx);
      $("#budget")[0].selectedIndex = v;
      v = n == -1 ? spd("set medium").match(/\((\d+)\)\s*$/)[1] : o.medium(adapters[n].idx);
      $("#medium")[0].value = v;
   }

   if (n == -2) {
      if (spd("gset reg_id_default").match(/=\s*(\d+)\s*$/)[1] == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
      if (spd("gset net_talk_default").match(/=\s*(\d+)\s*$/)[1] == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      if (spd("gset vari_fixed_default").match(/=\s*(\d+)\s*$/)[1] == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   else if (n == -1) {
      if (spd("set reg_id").match(/=\s*(\d+)\s*$/)[1] == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
      if (spd("set net_talk").match(/=\s*(\d+)\s*$/)[1] == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      if (spd("set vari_fixed").match(/=\s*(\d+)\s*$/)[1] == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   else {
      if (adapters[n].ras) {
         $("#reg_id").parent().hide();
         $("#net_talk").parent().hide();
      }
      else {
         if (o.prop(adapters[n].idx, "reg_id") == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
         if (o.prop(adapters[n].idx, "net_talk") == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      }
      if (o.prop(adapters[n].idx, "vari_fixed") == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   $("#con_settings").center().css('zIndex', 1).center().show().attr("data-n", n);
}

function change_ts_settings() {
   var n = $("#con_settings").attr("data-n");
   if (n == -2) {
      spd("gset reg_id_default " + (checked($("#reg_id")[0]) ? 3 : 2) + " -save;@flush");
      spd("gset net_talk_default " + (checked($("#net_talk")[0]) ? 1 : 0) + " -save;@flush");
      spd("gset vari_fixed_default " + (checked($("#vari_fixed")[0]) ? 0 : 1) + " -save;@flush");
   }
   else if (n == -1) {
      spd("set reg_id " + (checked($("#reg_id")[0]) ? 3 : 2) + ";@flush");
      spd("set net_talk " + (checked($("#net_talk")[0]) ? 1 : 0) + ";@flush");
      spd("set vari_fixed " + (checked($("#vari_fixed")[0]) ? 0 : 1) + ";@flush");
      spd("set budget " + $("#budget")[0].selectedIndex + ";@flush");
      spd("set medium " + $("#medium")[0].value + ";@flush");
   }
   else {
      if (adapters[n].ras) {
         ras_entry.status(adapters[n].idx) = checked($("#allow_ts")[0]) ? 2 : 1;
         ras_entry.prop(adapters[n].idx, "vari_fixed") = checked($("#vari_fixed")[0]) ? 0 : 1;
         ras_entry.budget(adapters[n].idx) = $("#budget")[0].selectedIndex;
         ras_entry.medium(adapters[n].idx) = $("#medium")[0].value;
      }
      else {
         netcard_entry.status(adapters[n].idx) = checked($("#allow_ts")[0]) ? 2 : 1;
         netcard_entry.prop(adapters[n].idx, "reg_id") = checked($("#reg_id")[0]) ? 3 : 2;
         netcard_entry.prop(adapters[n].idx, "net_talk") = checked($("#net_talk")[0]) ? 1 : 0;
         netcard_entry.prop(adapters[n].idx, "vari_fixed") = checked($("#vari_fixed")[0]) ? 0 : 1;
         netcard_entry.budget(adapters[n].idx) = $("#budget")[0].selectedIndex;
         netcard_entry.medium(adapters[n].idx) = $("#medium")[0].value;
      }
   }
   $("#con_settings").hide();
}

function resize_divs() {
   var win_height = $(window).height();
   $('#menu').height(win_height);
   $('#dlg').height(win_height);
}

function dialog() {
   $(".setting img").each(function() {
      var e = $(this);
      var id = e.attr("id");
      if (!id || !(id in checkboxes)) return;
      var m = spd("gset " + id).match(/=\s*(\d+)\s*$/);
      var v = m != null ? m[1] : "";
      e.attr("src", checkboxes[id].on == v ? "images/checkbox_on.png" : "images/checkbox_off.png");
      e.on("click", null, function(e) {
         e = e.target
         var id = e.id;
         var val = checked(e) ? checkboxes[id].off : checkboxes[id].on;  // toggles
         spd("gset " + id + " " + val + " -save;@flush");
         e.src = checked(e) ? "images/checkbox_off.png" : "images/checkbox_on.png";
      });
   });

   if (spd("ports").match("no ports currently open.")) $("#cur_con").hide();
   get_limits();
   $("#blocklist")[0].value = ini.query("user.ini", "iplist", "ipfilter");
   load_adapters();

   get_server_pwd();

   $("#con_settings div div.setting").find("img").on("click", null, function(e) {
      if (e.target.src.indexOf("checkbox_") != -1) {
         e.target.src = checked(e.target) ? "images/checkbox_off.png" : "images/checkbox_on.png";
         return false;
      }
      return true;
   });

   $('.info').hover(function() {$('#help').show();}, function() {$('#help').hide();});
   $('h2').wrapInner('<span class="h2_text"></span>');
   resize_divs();
}

window.onresize = resize_divs;
