"use strict";

// ----- browser support
function detect_browser() {
   var ua = window.navigator.userAgent;
   var msie = ua.indexOf("MSIE ");
   if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)) {
      alert("Internet Explorer is no longer supported.\nPlease use a newer browser.");
      return;
   }
   var b = window.navigator.userAgent.toLowerCase();
   var old_edge = false;
   if (b.indexOf("edge/") != -1) old_edge = true;
   else {
      var m = b.match(/edg\/(\d+)/);
      if (m && m[1] < 76) old_edge = true;
   }
   if (old_edge) {
      alert("Older Edge browsers are no longer supported.\nPlease use a new Edge 76+ version.");
   }
}

detect_browser();

const query_params = { };

(function() {
   const q = window.location.search.substr(1).split('&');
   for (let i = 0; i < q.length; ++i) {
      const f = q[i].split('=');
      if (f.length == 2) query_params[f[0]] = f[1];
      else query_params[q[i]] = true;
   }
})();

function ajax(params) {
   const async = "async" in params ? params.async : true;
   const r = new XMLHttpRequest();
   if (async) r.onreadystatechange = function () {
      try {
         if (r.readyState == XMLHttpRequest.DONE) {
            if (r.status >= 200 && r.status < 300) params.success(r.responseText, r);
            else params.error(r.status, r.statusText);
         }
      }
      catch (e) {
         if ("error" in params) params.error(0, e.message);
      }
   };
   r.open(params.verb || "GET", params.url, async);
   if ("request_headers" in params) {
      for (let i in params.request_headers) r.setRequestHeader(i, params.request_headers[i]);
   }
   if (params.no_cache) r.setRequestHeader("Cache-Control", "no-cache");
   if ("data" in params) r.send(data);
   else r.send();
   if (!async) {
      if ("success" in params) params.success(r.responseText, r);
      else return r.responseText;
   }
}

function JSON_parse(t) {
   try {
      return JSON.parse(t);
   }
   catch (e) {
      alert("JSON error: " + e.message + "\nText: " + t);
   }
}

function os_version() {
   const m = navigator.userAgent.match(/Windows NT (\d+)\.(\d+)/);
   if (m == null) return 0;
   return Number(m[1])*100 + Number(m[2]);
}

// webview2 support
const webview = {
   inject_move_events: function(el) {
      const self = this;
      let cx, cy, sx, sy, is_moving = false;
      el.onpointerdown = function(e) {
         e.target.setPointerCapture(e.pointerId);
         is_moving = true;
         cx = e.pageX; cy = e.pageY;
         sx = e.screenX; sy = e.screenY;
         self.mouse_cursor = el.style.cursor;
         el.style.cursor = "move";
      };
      el.onpointerup = function(e) {
         is_moving = false;
         e.target.releasePointerCapture(e.pointerId);
         el.style.cursor = self.mouse_cursor;
      };
      el.onpointermove = function(e) {
         if (!is_moving) return;
         if (e.target.classList.contains("cfsize")) {
            window.chrome.webview.postMessage("sizeBy " + (e.screenX - sx) + " " + (e.screenY - sy));
            sx = e.screenX; sy = e.screenY;
         }
         else window.chrome.webview.postMessage("moveBy " + (e.pageX - cx) + " " + (e.pageY - cy));
      };
      el.style.cursor = "pointer";
   },
   message: function(txt) {  // from host
      if (this.msg_handler) this.msg_handler(txt);
   },
   close: function() {
      if (window.chrome && window.chrome.webview)
         window.chrome.webview.postMessage("hide");
   },
   init: function () {
      if (!window.chrome || !window.chrome.webview) return;
      let e = document.querySelectorAll(".cfmove, .cfsize");
      for (let i = 0; i < e.length; ++i) e[i].style.display = "flex";
      const self = this;
      for (let i = 0; i < e.length; ++i) this.inject_move_events(e[i]);
      e = document.querySelectorAll(".cfclose");
      for (let i = 0; i < e.length; ++i) {
         e[i].onclick = function (e) { self.close(); };
         e[i].style.cursor = "pointer";
      }
      document.querySelectorAll('.sidebar-sticky')[0].style.marginTop = "-22px";
      document.querySelectorAll('.sidebar-sticky')[0].style.paddingTop = "30px";
      document.querySelectorAll('.sidebar-sticky')[0].style.height = "calc(100vh)";
      document.querySelectorAll('.setting')[0].style.border = "#7a8288 solid";
      document.querySelectorAll('.setting')[0].style.borderWidth = "0px 2px 2px 2px";
      window.chrome.webview.addEventListener("message", function (event) { self.message(event.data); });
      window.chrome.webview.postMessage("ready");
      let a = document.getElementsByTagName("a");
      for (let i = 0; i < a.length; ++i) {
         if (a[i].getAttribute("target") == "_blank") a[i].removeAttribute("target");
      }
   }
}
// --------

function param(name, val, section) {
   let u = "/cfosspeed/util?f=param&k=" + encodeURIComponent(name);
   if (section != undefined) u += "&d=" + encodeURIComponent(section);
   if (val !== undefined) u += "&v=" + encodeURIComponent(val);
   const res = ajax({ async: false, url: u });
   return res;
}

function spd_command(cmd) {
   return ajax({ async: false, url: "/cfosspeed/spd?" + encodeURIComponent(cmd) });
}

// ----- minimal jquery-like support

function $$(expr) {
   return Array.from(document.querySelectorAll(expr));
}
function show(el, disp) {
   const a = Array.isArray(el) ? el : [el];
   a.forEach(e => e.style.display = disp || "block");
}
function hide(el) {
   const a = Array.isArray(el) ? el : [el];
   a.forEach(e => e.style.display = "none");
}
function addClass(el, cls) {
   const a = Array.isArray(el) ? el : [el];
   a.forEach(e => e.classList.add(cls));
}
function removeClass(el, cls) {
   const a = Array.isArray(el) ? el : [el];
   a.forEach(e => e.classList.remove(cls));
}
