var tableNodeCurCon;
var prioClosedFlag = [0, 0, 0, 0, 0];
var refresh_done = false;

var ole_object = "cFosSpeed.Config";
var cFos_object;


try {
   cFos_object = new ActiveXObject(ole_object);
}
catch (x) {
   var m = new ml_object;
   alert(ole_object + "\n\n" + x.message + "\n\n" + m.ole_error);
   window.close();
}

function load_xml(s) {
   var xp = new ActiveXObject("Msxml2.DOMDocument.6.0");
   xp.setProperty("ProhibitDTD", false);
   xp.setProperty("ValidateOnParse", false);
   xp.setProperty("ResolveExternals", false);
   xp.setProperty("SelectionLanguage", "XPath");
   xp.loadXML(s);
   if (xp.parseError && xp.parseError.errorCode != 0)
      alert(xp.parseError.line + "/" + xp.parseError.linepos + ": " + xp.parseError.reason);
}

var freeze = false;
var resize = false;

function toggle_freeze() {
   freeze = !freeze;
   if (!freeze) {
      $('#continue_button').hide();
      $('#freeze_button').show();
      refresh();
   } else {
      $('#freeze_button').hide();
      $('#continue_button').show();
   }
}

var prio_text = ["", "lowest", "low", "default", "high", "higher", ""];
var prio_map = {
   "lowest": 1, "low": 2, "default": 3, "high": 4, "higher": 5,
   "lowest*": 1, "low*": 2, "default*": 3, "high*": 4, "higher*": 5
};

function get_new_prio(prio, adv) {
   for (var i = 0; i < prio_text.length; ++i) {
      if (prio_text[i] == prio) return prio_text[i + adv];
   }
   return "";
}

function prioritize_cons(prog, prot, prio) {
   var cmd = 'prioritize pair "' + prog + '" ' + prot + ' ' + prio;
   if (cFos_object) cFos_object.spd_command("@" + cmd);
   else $.ajax({ dataType: "text", async: false, url: "/cfosspeed/spd?" + encodeURIComponent(cmd) });
}

function cup(prog, prot, id, cla) {
   if (cla.indexOf('*') > -1) {
      cla = cla.substring(0, cla.length - 1);
   }
   //var o = get_prio_class(id);
   //var prio = get_new_prio(o.cls, 1);
   if (cla != "high") {
      var prio = get_new_prio(cla, 1);
      if (!prio) return;
      prioritize_cons(prog, prot, prio);
      //adjust_class(o.e, prio + '*');
   }
}

function cdn(prog, prot, id, cla) {
   if (cla.indexOf('*') > -1) {
      cla = cla.substring(0, cla.length - 1);
   }
   //var o = get_prio_class(id);
   //var prio = get_new_prio(o.cls, -1);
   var prio = get_new_prio(cla, -1);
   if (!prio) return;
   prioritize_cons(prog, prot, prio);
   //adjust_class(o.e, prio + '*');
}

function coff(prog, prot, id) {
   prioritize_cons(prog, prot, "none");
   var o = get_prio_class(id);
   adjust_class(o.e, $(o.e).text().replace(/\*$/, ""));
}

function make_id(s) {
   var id = "";
   for (var i = 0; i < s.length; ++i) {
      var h = s.charCodeAt(i).toString(16);
      while (h.length < 4) h = '0' + h;
      id += h;
   }
   return "x" + id;
}

function refresh() {
   var s = "@connections -raw -cps -vol -rtt -class";
   if (("cFos_object" in window) && cFos_object) s = cFos_object.spd_command(s);
   else $.ajax({ dataType: "text", async: false, url: "/cfosspeed/spd?" + encodeURIComponent(s), success: function (d) { s = d; } });

   var lines = s.split('\n');
   var corr = 0;

   var arrayJson = new Array();

   for (var i = 0; i < lines.length; ++i) {
      var l = lines[i].replace(/^\s+|\s+$/g, "");
      if (!l) {
         ++corr;
         continue;
      }

      var array = new Array();
      var res = l.replace(/\s+/g, ' ');
      array = res.split(' ');

      var idx = -1;
      for (var j = 0; j < arrayJson.length; j++) {
         if (arrayJson[j].p == array[3]) {
            idx = j;
         }
      }

      if (idx >= 0) {
         arrayJson[idx].s = Number(arrayJson[idx].s) + Number(numeral(array[7].toLowerCase()).value());
         arrayJson[idx].n = Number(arrayJson[idx].n) + Number(numeral(array[8].toLowerCase()).value());
      } else {
         var obj = new Object();
         obj.p = array[3];
         obj.t = array[4];
         obj.s = Number(array[7]);
         obj.n = Number(array[8]);
         if (!obj.n) { obj.n = 0; };
         obj.c = array[(array.length - 1)];
         obj.cnum = Number(prio_map[obj.c]);
         if (refresh_done && prio_items.hasOwnProperty(obj.p)) {
            obj.g = prio_items[obj.p].filter;
            obj.d = prio_items[obj.p].desc;
         } else {
            obj.g = "";
            obj.d = "";
         }
         arrayJson.push(obj);
      }
   }
   var myJSONString = JSON.stringify(arrayJson);

   var c;
   // var is_hta = false;

   c = JSON.parse(myJSONString);

   if (c.length > 0 && c[c.length - 1] == null) c.splice(c.length - 1, 1);

   c = c.sort(function (a, b) {
      return a.cnum < b.cnum ? 1 : -1;
   });

   var rowNum = tableNodeCurCon.rows.length;
   for (i = 0; i < rowNum; i++) {
      tableNodeCurCon.deleteRow(i);
      rowNum = rowNum - 1;
      i = i - 1;
   }

   var gSelValue = $("#categoriesSelect").val();

   var priority_used = new Array(5);
   for (i = 0; i < 5; i++) {
      priority_used[i] = 0;
   }

   // var in_use = {};
   for (i = 0; i < c.length; ++i) {
      var o = c[i];
      var id = make_id(o.p + "|" + o.t);
      // in_use[id] = true;
      // var el = $("#" + id);
      var a = "('" + o.p + "','" + o.t + "','" + id + "','" + o.c + "')";

      if (gSelValue != "All") {
         if (o.g != gSelValue) {
            continue;
         }
      }

      //ToDo: we should reduce statement with for-loop in the future

      if ((o.c == 'higher') || (o.c == 'higher*')) {
         if (priority_used[0] == 0) {
            construct_priority_line("TURBO", 0);
            priority_used[0] = 1;
         }
         if (prioClosedFlag[0] == 1) {
            continue;
         }
      }

      if ((o.c == 'high') || (o.c == 'high*')) {
         if (priority_used[1] == 0) {
            construct_priority_line("HIGH", 1);
            priority_used[1] = 1;
         }
         if (prioClosedFlag[1] == 1) {
            continue;
         }
      }

      if ((o.c == 'default') || (o.c == 'default*')) {
         if (priority_used[2] == 0) {
            construct_priority_line("DEFAULT", 2);
            priority_used[2] = 1;
         }
         if (prioClosedFlag[2] == 1) {
            continue;
         }
      }

      if ((o.c == 'low') || (o.c == 'low*')) {
         if (priority_used[3] == 0) {
            construct_priority_line("LOW", 3);
            priority_used[3] = 1;
         }
         if (prioClosedFlag[3] == 1) {
            continue;
         }
      }

      if ((o.c == 'lowest') || (o.c == 'lowest*')) {
         if (priority_used[4] == 0) {
            construct_priority_line("LOWEST", 4);
            priority_used[4] = 1;
         }
         if (prioClosedFlag[4] == 1) {
            continue;
         }
      }

      var rxSpeedPercentage = Math.round(o.n * 100 / 105000);
      var txSpeedPercentage = Math.round(o.s * 100 / 105000);
      rxSpeedPercentage = (rxSpeedPercentage > 100) ? 100 : rxSpeedPercentage;
      txSpeedPercentage = (txSpeedPercentage > 100) ? 100 : txSpeedPercentage;

      // icon_src = is_hta ? "images/program_icon.png" : "/cfosspeed/stats/icon?exe=" + encodeURIComponent(o.p);
      // tdNodeIcon.innerHTML = '<img id="programIcon" src="' + icon_src + '" draggable="true"/>';

      var appendStr =
         '<tr class="newConnection">\
            <td>\
               <div id="' + o.g.replace(/\s+/g, "_") + '">\
                  <div id=categoryName title="' + o.g.toUpperCase() + '">' + o.g.toUpperCase() + '</div>\
               </div>\
            </td>\
            <td><div id="programName">' + o.d + '  (' + o.p + ')' + '</div></td>\
            <td>\
               <div class="programSpeedBar">\
                  <div class="rxSpeedBar" style=" width:' + rxSpeedPercentage + '%;"></div>\
                  <div class="txSpeedBar" style=" width:' + txSpeedPercentage + '%;"></div>\
               </div>\
            </td>\
            <td>\
               <div id="programRxPerSec">' + o.n + ' rx/s' + '</div>\
               <div id="programTxPerSec">' + o.s + ' tx/s' + '</div>\
            </td>';

      if ((o.c == 'high') || (o.c == 'high*')) {
         appendStr +=
            '<td><div id="prioStatusStr">' + o.c.toUpperCase().replace("*", "") + '</div></td>\
            <td>\
               <div class="prioDown" onclick="cdn' + a + '"></div>\
               <div id="prioUpTurbo"></div>\
            </td>';
      } else if ((o.c == 'higher') || (o.c == 'higher*')) {
         appendStr +=
            '<td><div id="prioStatusStr"  style="color:#242526;">' + o.c.toUpperCase().replace("*", "") + '</div></td>\
            <td>\
               <div id="prioDownTurbo"></div>\
               <div id="prioUpTurbo"></div>\
            </td>';
      } else {
         appendStr +=
            '<td><div id="prioStatusStr">' + o.c.toUpperCase().replace("*", "") + '</div></td>\
            <td>\
               <div class="prioDown" onclick="cdn' + a + '"></div>\
               <div class="prioUp" onclick="cup' + a + '"></div>\
            </td>';
      }

      var turboImage;
      if ((o.c == 'higher') || (o.c == 'higher*')) {
         turbo_map[o.p] = true;
         turboImage = "asus/images/slider/turbo_icon_d.png";
      } else {
         if (o.p in turbo_map) {
            delete turbo_map[o.p];
            save_turbo_settings();
         }
         turboImage = "asus/images/slider/turbo_icon_n.png";
      }
      var b = "('" + o.p + "','" + i + "')";
      appendStr +=
         '<td>\
            <img id="turbo_img' + i + '" src="' + turboImage + '" onclick="set_program_turbo' + b + '" style="cursor:hand;" ondragstart="return false;">\
         </td>';

      appendStr += '</tr>';

      var newConnection = $(appendStr);
      $(tableNodeCurCon).append(newConnection);
   }

   $("#co_box").append(tableNodeCurCon);

   resize = false;
   refresh_done = true;
   setTimeout("refresh()", 1000);
}

function construct_priority_line(priority, prioIndex) {
   trNodePrioLine = tableNodeCurCon.insertRow();
   tdNodePrioLine = trNodePrioLine.insertCell();
   tdNodePrioLine.colSpan = "8";

   if (prioClosedFlag[prioIndex] == 1) {
      tdNodePrioLine.innerHTML += '<span class="openBtn" onmousedown="change_close_status(' + prioIndex + ')"></span>';
      tdNodePrioLine.innerHTML += '<span class="insideLine" ondblclick="change_close_status(' + prioIndex + ')">' + priority + '</span>';
   } else {
      tdNodePrioLine.innerHTML += '<span class="closeBtn" onmousedown="change_close_status(' + prioIndex + ')"></span>';
      tdNodePrioLine.innerHTML += '<span class="insideLine" ondblclick="change_close_status(' + prioIndex + ')">' + priority + '</span>';
   }
}

function change_close_status(prioIndex) {
   setTimeout(function () {
      (prioClosedFlag[prioIndex] == 0) ? prioClosedFlag[prioIndex] = 1 : prioClosedFlag[prioIndex] = 0;
   }, 0);
}

function resize_divs() {
   resize = true;
   $('#co_box').width(770);
   $('#co_box').height(290);
}

function init_console() {

   //ToDo: we should implement Multi-Selection

   $('#categoriesSelect').multiselect({
      enableHTML: true,
      optionLabel: function (element) {
         return '<img src="' + $(element).attr('data-img') + '"> ' + $(element).text();
      },
   });

   tableNodeCurCon = document.createElement("table");

   ini_file.set("global.ini", "All", "last_console_dialog", "simple");
   resize_divs();
   refresh();
}

window.onresize = resize_divs;
