﻿
var netcard_entry = {
   lan_sec_name: "LAN_connections",
   org: [ ], name: [ ], info: [ ], st: [ ],
   load: function() {
      org = [ ]; name = [ ]; info = [ ]; st = [ ];
      var o = ini_file.query_section("global.ini", this.lan_sec_name);
      for (var i=0; i < o.k.length; ++i) {
         if (o.v[i] & 4) continue;
         var k = o.k[i];
         var info = "", name = k;
         var idx = k.indexOf(" $#MAC ");
         if (idx != -1) {
            info = name.substr(idx + 3);
            name = name.substr(0, idx);
         }
         this.org.push(k);
         this.st.push(o.v[i]);
         this.info.push(info);
         this.name.push(name);
      }
   },
   get_mac: function(idx) {
      var p = this.info[idx].indexOf(',', 4);
      return p != -1 ? this.info[idx].substr(4, p-4) : "00-00-00-00-00-00";
   },
   length: function() { return this.st.length; },
   get_name: function(idx) {
      if (idx >= this.name.length) return "";
      return this.name[idx];
   },
   get_status: function(idx) {
      if (idx >= this.st.length) return 4;
      return this.st[idx];
   },
   set_status: function(idx, st) {
      if (idx >= this.st.length) return;
      this.st[idx] = st;
      ini_file.set("global.ini", this.lan_sec_name, this.org[idx], st);
      ini_file.flush("global.ini");
      spd_command("@set_bind_event");
   },
   get_medium: function(idx) {
      if (idx >= this.st.length) return 0;
      return ini_file.get("data.ini", "Router-" + this.get_mac(idx), "Medium") || 0;
   },
   set_medium: function(idx, val) {
      if (idx >= this.st.length) return;
      ini_file.set("data.ini", "Router-" + this.get_mac(idx), "Medium", val)
      ini_file.flush("data.ini");
      spd_command("@medium_changed");
   },
   get_budget: function(idx) {
      if (idx >= this.st.length) return 0;
      return ini_file.get("data.ini", "Router-" + this.get_mac(idx), "budget") || 0;
   },
   set_budget: function(idx, val) {
      if (idx >= this.st.length) return;
      ini_file.set("data.ini", "Router-" + this.get_mac(idx), "budget", val)
      ini_file.flush("data.ini");
      spd_command("@budget_changed");
   },
   get_prop: function(idx, cname) {
      if (idx >= this.st.length) return "";
      var v = ini_file.get("data.ini", "Router-" + this.get_mac(idx), cname);
      if (v == "") v = ini_file.get("data.ini", cname + "_default") || 1;
      return v;
   },
   set_prop: function(idx, cname, val) {
      if (idx >= this.st.length) return;
      ini_file.set("data.ini", "Router-" + this.get_mac(idx), cname, val);
      ini_file.flush("data.ini");
      spd_command("@settings_changed");
   },
   get_router_info: function(idx) {
      if (idx >= this.st.length) return "";
      return this.info[idx];
   }
};

var ras_entry = {
   wan_sec_name: "WAN_connections",
   name: [ ],
   translate_ini_key: function(s) {
      return s.replace(/^\s+|\s+$|\0/g, "").replace(/  /g, " ").replace(/\[/g, "(").replace(/\]/g, ")");
   },
   load: function() {
      var res = "";
      ajax({ dataType: "text", async: false, url: "/cfosspeed/util?f=ras_entry_names", success: function(d) { res = d; }});
      this.name = JSON.parse(res);
   },
   length: function() { return this.name.length; },
   get_name: function(idx) {
      if (idx >= this.name.length) return "";
      return this.name[idx];
   },
   get_status: function(idx) {
      if (idx >= this.name.length) return 0;
      return ini_file.get("global.ini", wan_sec_name, this.translate_ini_key(name[idx])) || 0;
   },
   set_status: function(idx, st) {
      if (idx >= this.name.length) return;
      ini_file.set("global.ini", this.wan_sec_name, this.translate_ini_key(name[idx]), st);
      ini_file.flush("global.ini");
   },
   get_medium: function(idx) {
      if (idx >= this.name.length) return 0;
      return ini_file.get("data.ini", "WAN-" + this.translate_ini_key(name[idx]), "Medium") || 0;
   },
   set_medium: function(idx, m) {
      if (idx >= this.name.length) return;
      ini_file.set("data.ini", "WAN-" + this.translate_ini_key(name[idx]), "Medium", m)
      ini_file.flush("data.ini");
      spd_command("@medium_changed");
   },
   get_budget: function(idx) {
      if (idx >= this.name.length) return 0;
      return ini_file.get("data.ini", "WAN-" + this.translate_ini_key(name[idx]), "budget") || 0;
   },
   set_budget: function(idx, m) {
      if (idx >= this.name.length) return;
      ini_file.set("data.ini", "WAN-" + this.translate_ini_key(name[idx]), "budget", m)
      ini_file.flush("data.ini");
      spd_command("@budget_changed");
   },
   get_prop: function(idx, cname) {
      if (idx >= this.name.length) return "";
      var v = ini_file.get("data.ini", "WAN-" + this.translate_ini_key(name[idx]), cname);
      if (v == "") v = ini_file.get("data.ini", cname + "_default") || 1;
      return v;
   },
   set_prop: function(idx, cname, val) {
      if (idx >= this.name.length) return;
      ini_file.set("data.ini", "WAN-" + this.translate_ini_key(name[idx]), cname, m);
      ini_file.flush("data.ini");
      spd_command("@settings_changed");
   }
};

function get_val(name) {
   var s = spd_command("@set " + name);
   var m = s.match(/= *(.*)/);
   if (m == null) return "";
   s = jQuery.trim(m[1]);
   if (s == "inf") return "0";
   return String(parseInt(s / 1000));
}

function set_val(name, val) {
   if (val == 0) val = "inf";
   else val *= 1000;
   spd_command("@set " + name + " " + val);
}

function get_limits() {
   $("#rx_limit")[0].value = get_val("rx_limit");
   $("#tx_limit")[0].value = get_val("tx_limit");
   $("#max_rx").text(get_val("maxrx"));
   $("#max_tx").text(get_val("maxtxraw"));
}

function set_limits() {
   set_val("rx_limit", $("#rx_limit")[0].value);
   set_val("tx_limit", $("#tx_limit")[0].value);
   get_limits();
}

var old_server_pwd = null;

function get_server_pwd() {
   var s = get_param("server_password");
   $("#server_pwd")[0].value = s;
   old_server_pwd = s;
   if (s == "") {
      $("#no_server_pwd").show();
      $("#has_server_pwd").hide();
   }
   else {
      $("#no_server_pwd").hide();
      $("#has_server_pwd").show();
   }
}

function set_server_pwd() {
   var s = $("#server_pwd")[0].value;
   if (s != "" && s != old_server_pwd) s = "!" + s;
   set_param("server_password", s);
   get_server_pwd();
}

function toggle_blocklist() {
   var v = ini_file.get("user.ini", "iplist", "ipfilter");
   var active = v != "";
   active = !active;
   if (active) {
      var program_data_dir = "";
      ajax({ dataType: "text", async: false, url: "/cfosspeed/util?f=program_data_dir", success: function(d) { program_data_dir = d; }});
      if (program_data_dir != "") {
         ini_file.set("user.ini", "iplist", "ipfilter", program_data_dir + "blocklist.txt");
         $("#blocklist").attr("src", "images/checkbox_on.png");
      }
   }
   else {
      ini_file.set("user.ini", "iplist", "ipfilter", "");
      $("#blocklist").attr("src", "images/checkbox_off.png");
   }
   ini_file.flush("user.ini");
   spd_command("@reload -iplist");
}

var checkboxes = {
   expand_rwin: { on: 1, off: 0 }, latency: { on: 1, off: 2 }, avoid_loss: { on: 1, off: 0 },
   handle_mss: { on: 1, off: 0 }, strict_rtp_check: { on: 1, off: 0 }, firewall: { on: 1, off: 0 },
   fg_detect: { on: 1, off: 0 }, router_info: { on: 1, off: 0 },
   store_dns_names: { on: 1, off: 0 },
   send_usage_metadata: { on: 1, off: 0 }
};

var adapters = [ ];

function load_adapters() {
   // status: 1 = ts enabled, 2 = ts disabled
   ras_entry.load();
   var i, len = ras_entry.length();
   for (i=0; i < len; ++i) adapters.push({ ras: true, name: ras_entry.get_name(i), idx: i, router: ""});
   netcard_entry.load();
   len = netcard_entry.length();
   for (i=0; i < len; ++i) adapters.push({ ras: false, name: netcard_entry.get_name(i), idx: i, router: netcard_entry.get_router_info(i)});
   adapters.sort(function(l, r) {
      if (l.router < r.router) return 1;
      if (l.router > r.router) return -1;
      return 0;
   });
   var s = "";
   for (i=0; i < adapters.length; ++i) {
      var r = adapters[i].router ? '<br/><span class="xxxsmall">' + adapters[i].router + '</span>' : "";
      s += '<tr><td>' + adapters[i].name + r + '</td>'
         + '<td style="padding-left: 12px"><img class="button" src="images/settings.png" onmouseover=\'this.src="images/settings_a.png";\' onmouseout=\'this.src="images/settings.png";\' alt="' + ml_object.settings + '" title="' + ml_object.settings + '" onclick="show_ts_settings(' + i + ')"/></td></tr>';
   }
   $("#con_list").append(s);
}

function checked(e) {
   return e.src.indexOf("checkbox_on") != -1;
}

// default: no ts, no budget, no medium
// current: no ts, spd set budget 0 (off) 1-10, spd set medium

function show_ts_settings(n) {
   var d = $("#con_settings div div.setting");
   d.show();
   d.find("img").attr("src", "images/checkbox_off.png");
   var o = null;
   if (n >= 0) o = adapters[n].ras ? ras_entry : netcard_entry;
   if (n < 0) $("#allow_ts").parent().hide();
   else if (o.get_status(adapters[n].idx) != 1) $("#allow_ts").attr("src", "images/checkbox_on.png");

   if (n == -2) {
      $("#budget").parent().hide();
      $("#medium").parent().hide();
   }
   else {
      var v = n == -1 ? spd_command("@set budget").match(/=\s*(\d+)\s*$/)[1] : o.get_budget(adapters[n].idx);
      $("#budget")[0].selectedIndex = v;
      v = n == -1 ? spd_command("@set medium").match(/\((\d+)\)\s*$/)[1] : o.get_medium(adapters[n].idx);
      $("#medium")[0].value = v;
   }

   if (n == -2) {
      if (spd_command("@gset reg_id_default").match(/=\s*(\d+)\s*$/)[1] == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
      if (spd_command("@gset net_talk_default").match(/=\s*(\d+)\s*$/)[1] == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      if (spd_command("@gset vari_fixed_default").match(/=\s*(\d+)\s*$/)[1] == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   else if (n == -1) {
      if (spd_command("@set reg_id").match(/=\s*(\d+)\s*$/)[1] == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
      if (spd_command("@set net_talk").match(/=\s*(\d+)\s*$/)[1] == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      if (spd_command("@set vari_fixed").match(/=\s*(\d+)\s*$/)[1] == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   else {
      if (adapters[n].ras) {
         $("#reg_id").parent().hide();
         $("#net_talk").parent().hide();
      }
      else {
         if (o.get_prop(adapters[n].idx, "reg_id") == 3) $("#reg_id").attr("src", "images/checkbox_on.png");
         if (o.get_prop(adapters[n].idx, "net_talk") == 1) $("#net_talk").attr("src", "images/checkbox_on.png");
      }
      if (o.get_prop(adapters[n].idx, "vari_fixed") == 0) $("#vari_fixed").attr("src", "images/checkbox_on.png");
   }
   $("#con_settings").center().css('zIndex', 1).center().show().attr("data-n", n);
}

function change_ts_settings() {
   var n = $("#con_settings").attr("data-n");
   if (n == -2) {
      spd_command("@gset reg_id_default " + (checked($("#reg_id")[0]) ? 3 : 2) + " -save;@flush");
      spd_command("@gset net_talk_default " + (checked($("#net_talk")[0]) ? 1 : 0) + " -save;@flush");
      spd_command("@gset vari_fixed_default " + (checked($("#vari_fixed")[0]) ? 0 : 1) + " -save;@flush");
   }
   else if (n == -1) {
      spd_command("@set reg_id " + (checked($("#reg_id")[0]) ? 3 : 2) + ";@flush");
      spd_command("@set net_talk " + (checked($("#net_talk")[0]) ? 1 : 0) + ";@flush");
      spd_command("@set vari_fixed " + (checked($("#vari_fixed")[0]) ? 0 : 1) + ";@flush");
      spd_command("@set budget " + $("#budget")[0].selectedIndex + ";@flush");
      spd_command("@set medium " + $("#medium")[0].value + ";@flush");
   }
   else {
      if (adapters[n].ras) {
         ras_entry.set_status(adapters[n].idx, checked($("#allow_ts")[0]) ? 2 : 1);
         ras_entry.set_prop(adapters[n].idx, "vari_fixed", checked($("#vari_fixed")[0]) ? 0 : 1);
         ras_entry.set_budget(adapters[n].idx, $("#budget")[0].selectedIndex);
         ras_entry.set_medium(adapters[n].idx, $("#medium")[0].value);
      }
      else {
         netcard_entry.set_status(adapters[n].idx, checked($("#allow_ts")[0]) ? 2 : 1);
         netcard_entry.set_prop(adapters[n].idx, "reg_id", checked($("#reg_id")[0]) ? 3 : 2);
         netcard_entry.set_prop(adapters[n].idx, "net_talk", checked($("#net_talk")[0]) ? 1 : 0);
         netcard_entry.set_prop(adapters[n].idx, "vari_fixed", checked($("#vari_fixed")[0]) ? 0 : 1);
         netcard_entry.set_budget(adapters[n].idx, $("#budget")[0].selectedIndex);
         netcard_entry.set_medium(adapters[n].idx, $("#medium")[0].value);
      }
   }
   $("#con_settings").hide();
}

function resize_divs() {
   var win_height = $(window).height();
   $('#menu').height(win_height);
   $('#dlg').height(win_height);
}

function dialog() {
   $(".setting img").each(function() {
      var e = $(this);
      var id = e.attr("id");
      if (!id || !(id in checkboxes)) return;
      var m = spd_command("@gset " + id).match(/=\s*(\d+)\s*$/);
      var v = m != null ? m[1] : "";
      e.attr("src", checkboxes[id].on == v ? "images/checkbox_on.png" : "images/checkbox_off.png");
      e.on("click", null, function(e) {
         e = e.target
         var id = e.id;
         var val = checked(e) ? checkboxes[id].off : checkboxes[id].on;  // toggles
         spd_command("@gset " + id + " " + val + " -save;@flush");
         e.src = checked(e) ? "images/checkbox_off.png" : "images/checkbox_on.png";
      });
   });

   if (spd_command("@ports").match("no ports currently open.")) $("#cur_con").hide();
   get_limits();
   $("#blocklist").attr("src", ini_file.get("user.ini", "iplist", "ipfilter") == "" ? "images/checkbox_off.png" : "images/checkbox_on.png")
   $("#blocklist").on("click", null, toggle_blocklist);
   load_adapters();

   get_server_pwd();

   $("#con_settings div div.setting").find("img").on("click", null, function(e) {
      if (e.target.src.indexOf("checkbox_") != -1) {
         e.target.src = checked(e.target) ? "images/checkbox_off.png" : "images/checkbox_on.png";
         return false;
      }
      return true;
   });

   $('.info').hover(function() {$('#help').show();}, function() {$('#help').hide();});
   $('h2').wrapInner('<span class="h2_text"></span>');
   resize_divs();
}

window.onresize = resize_divs;
