
var ini_name = "data.ini";
var budget = [ ];   // budgets are numbered from 1..10, but must be stored in this array from 0..9

function read_budget(num) {
   var o = { };
   var t = ini_file.get(ini_name, "budget"+num, "time_used");
   if (t == "") t = "0:00";
   o.time_used = t;
   o.volume_used = ini_file.get(ini_name, "budget"+num, "volume_used");
   if (o.volume_used == "") o.volume_used = "0";
   o.hard_limit = ini_file.get(ini_name, "budget"+num, "hard_limit") == "1";
   o.hl_img = (o.hard_limit ? "images/checkbox_on.png" : "images/checkbox_off.png");
   o.time_limit = ini_file.get(ini_name, "budget"+num, "time_limit");
   o.volume_limit = ini_file.get(ini_name, "budget"+num, "volume_limit");
   o.reset_day = ini_file.get(ini_name, "budget"+num, "reset_day");
   if (o.reset_day == "") o.reset_day = "1";
   o.unit = ini_file.get(ini_name, "budget"+num, "volume_limit_unit");
   if (o.unit == "") o.unit = 2;
   return o;
}

function write_budget(num) {
   ini_file.set(ini_name, "budget"+num, "hard_limit", budget[num-1].hard_limit ? "1" : "0");
   var r = $($("#budgets tbody tr")[num]);
   var i = r.find("td input");
   ini_file.set(ini_name, "budget"+num, "time_limit", i[0].value);
   ini_file.set(ini_name, "budget"+num, "volume_limit", i[1].value);
   var s = r.find("select");
   ini_file.set(ini_name, "budget"+num, "volume_limit_unit", s[0].value);
   ini_file.set(ini_name, "budget"+num, "reset_day", s[1].selectedIndex+1);
   ini_file.flush(ini_name);
}

function reset_budget(n) {
   spd_command("@reset_budget "+n);
   var r = $("#budgets tr:eq(" + n + ")");
   r.find("td:eq(1)").text("0:00");
   r.find("td:eq(2)").text("0");
}

function exit_dialog(save) {
   if (save) {
      for (var i=1; i < 11; ++i) write_budget(i);
      spd_command("@budget_changed");
   }
   else window.location.reload();
}

function toggle_hl(num) {
   var r = $($("#budgets tbody tr")[num]);
   --num;
   budget[num].hard_limit = !budget[num].hard_limit;
   r.find("td img").attr("src", budget[num].hard_limit ? "images/checkbox_on.png" : "images/checkbox_off.png");
}

function resize_divs() {
   var win_height = $(window).height();
   $('#menu').height(win_height);
   $('#tablebox').height(win_height - $('#top').height() - 124);
}

function dialog() {
   var i, days31 = "";
   for (var i=1; i < 32; ++i) days31 += '<option value="' + i + '">' + i + '</option>';
   var kmg = '<option value="0">K</option><option value="1">M</option><option value="2">G</option>';

   spd_command("@save_budgets");
   var t = "";
   for (i=1; i < 11; ++i) {
      var b = read_budget(i);
      budget.push(b);
      var s = '<tr><td class="info1">##</td><td>#time_used</td><td>#volume_used</td>'
         + '<td><button onclick="reset_budget(##)">' + ml_object.reset + '</button></td>'
         + '<td class="info2"><img src="#hl_img" class="checkbox" onclick="toggle_hl(##)"/></td>'
         + '<td><input class="text frame right" type="text" style="width:50px" value="#time_limit"/></td>'
         + '<td style="white-space:nowrap"><input class="frame right" type="text" style="width:50px" value="#volume_limit"/>'
            + ' <select>' + kmg + '</select></td>'
         + '<td><select>' + days31 + '</select></td></tr>';
      s = s.replace(/##/g, i);
      for (var e in b) s = s.replace(new RegExp("#" + e, "g"), b[e]);
      t += s;
   }
   resize_divs();
   $("#budgets tbody").append(t);
   for (i=1; i < 11; ++i) {
      var s = $("#budgets tr:eq(" + i + ")").find("select");
      s[0].value = budget[i-1].unit;
      s[1].value = budget[i-1].reset_day;
   }
   $('.info1').hover(function() {$('#help1').show();}, function() {$('#help1').hide();});
   $('.info2').hover(function() {$('#help2').show();}, function() {$('#help2').hide();});

}

window.onresize = resize_divs;
