
var freeze = false;
var current_prio = -1;
var sort_num = -1;
var ascending;
var cmode = "";   // "tcp" or "udp"

var skey = new Array('p', 'l', 'o', 'g', '7', 't', 'r', 'T', 'R', 'd', 'c');
var prio_text = ["", "lowest", "low", "default", "high", "higher"];

var sorter_html = "";

function set_sort(num) {
   if (num == sort_num) ascending = !ascending;
   else {
      sort_num = num;
      ascending = false;
   }
   for (var i=0; i < 11; ++i) {
      var el = $("#s"+i);
      if (num == i) el[0].className = ascending ? "c_set_up" : "c_set_down";
      else el[0].className = "c_not_set";
   }
   sorter_html = $("#sorters")[0].rows.item(0).outerHTML;
   if (freeze) refresh();
}

function set_cur_prio(val) {
   current_prio = val;
   $('#r1name').text(prio_text[val]);
}

function prio_mouse_up(e) {
   if (clicked_el.tagName.toLowerCase() != "img") return true;
   else if (clicked_el.src.indexOf("prio_") != -1) {
      current_prio = show_prio(e.pageX);
      return false;
   }
   return true;
}

function prio_setup(idx) {
   var prio;
   try {
      var r = $("#sorters")[0].rows.item(idx+1);
      $("#local_addr").html(r.cells.item(1).innerHTML);
      $("#local_addr_off").html(r.cells.item(1).innerHTML);
      $("#remote_addr").html(r.cells.item(2).innerHTML);
      $("#remote_addr_off").html(r.cells.item(2).innerHTML);
      var prot = r.cells.item(4).innerHTML;
      $("#prot").html(prot);
      $("#prot_off").html(prot);
      $("#prot2_off").html(prot);
      $("#prot3").html(prot);
      var program = r.cells.item(3).innerHTML;
      $("#program").html(program);
      $("#program_off").html(program);
      $("#program2_off").html(program);
      $("#program3").html(program);
      cmode = r.cells.item(0).innerHTML;
      var prio_val = r.cells.item(10).innerHTML.toLowerCase();
   }
   catch(err) { return; }
   if (prio_val.indexOf('*') != -1) {
      $('#settings_frame_off').show();
      return;
   }
   for (prio=0; prio < prio_text.length; ++prio) if (prio_text[prio] == prio_val) break;
   if (prio > 5) return;   // unknown prio, like 'working'
   current_prio = prio;

   $('#settings_frame').show();
   var img = $("#np_prio");
   img.attr("src", "images/prio_" + prio + ".png").attr("alt", prio_names[prio])
      .on(mouse_evt_obj, null, { mouse_up_handler: prio_mouse_up });
   img.next().text(prio_names[prio]);
}

function close_prio_box() {
   $("#np_prio").off(mouse_evt_obj);
   $('#settings_frame').hide();
   $('#settings_frame_off').hide();
}

function do_apply(spd_cmd) {
   spd_cmd += " " + (current_prio == -1 ? "none" : prio_text[current_prio]);
   if (("cFos_object" in window) && cFos_object) cFos_object.spd_command(spd_cmd);
   else $.ajax({ dataType: "text", async: false, url: "/cfosspeed/spd?" + encodeURIComponent(spd_cmd) });
   close_prio_box();
}

function apply_prioritization_off() {
   var r = document.getElementsByName("ptype_off");
   var val = "";
   for (var i=0; i < r.length; ++i) if (r[i].checked) val = r[i].value;

   var spd_cmd = "prioritize ";
   current_prio = -1;
   if (val == "con") do_apply(spd_cmd + cmode + " " + $("#local_addr_off").text() + " " + $("#remote_addr_off").text());
   else if (val == "prot") do_apply(spd_cmd + "prot " + $("#prot_off").text());
   else if (val == "prog") do_apply(spd_cmd + 'prog "' + $("#program_off").text() + '"');
   else if (val == "prog_prot") do_apply(spd_cmd + 'pair "' + $("#program2_off").text() + '" ' + $("#prot2_off").text());
}

function apply_prioritization() {
   var r = document.getElementsByName("ptype");
   var val = "";
   for (var i=0; i < r.length; ++i) if (r[i].checked) val = r[i].value;

   var spd_cmd = "prioritize ";
   if (val == "con") do_apply(spd_cmd + cmode + " " + $("#local_addr").text() + " " + $("#remote_addr").text());
   else if (val == "prot") do_apply(spd_cmd + "prot " + $("#prot").text());
   else if (val == "prog") do_apply(spd_cmd + 'prog "' + $("#program").text() + '"');
   else if (val == "prog_prot") do_apply(spd_cmd + 'pair "' + $("#program3").text() + '" ' + $("#prot3").text());
}

function refresh() {
   if (freeze) return;
   var s = "@connections -raw -cps -vol -class";
   if (sort_num != -1) s += " -sort:" + skey[sort_num] + (ascending ? "" : "-");
   if (("cFos_object" in window) && cFos_object) s = cFos_object.spd_command(s);
   else $.ajax({ dataType: "text", async: false, url: "/cfosspeed/spd?" + encodeURIComponent(s), success: function(d) { s = d; }});

   if (!sorter_html) sorter_html = $("#sorter_body").html();
   var h = "";
   var lines = s.split('\n');
   var corr = 0;
   for (var i=0; i < lines.length; ++i) {
      var l = lines[i].replace(/^\s+|\s+$/g, "");
      if (!l) {
         ++corr;
         continue;
      }
      h += '<tr class="list" onclick="prio_setup('+(i-corr)+')"><td class="entry">' + l.replace(/[ \t]+/g, '</td><td class="entry">').replace(/([^<])\//g, "$1 ") + '</td></tr>';
   }
   $("#sorters")[0].outerHTML =
      '<table id="sorters" cellpadding="0" cellspacing="0"><tbody id="sorter_body">' + sorter_html + h + '</tbody></table>';
   try {
      if ( $('#sorters').width() > $(window).width() - 32) window.resizeBy($('#sorters').width()-$(window).width() + 32,0);
   }
   catch (x) { }

   setTimeout("refresh()", 1000);
}

function resize_divs() {
   $('#c_box').height($(window).height() - $('#pageheader').height() - 20);
}

function toggle_freeze() {
   freeze = !freeze;
   if (!freeze) {
      $('#continue_button').hide();
      $('#freeze_button').show();
      refresh();
   }  else {
      $('#freeze_button').hide();
      $('#continue_button').show();
   }
}

function init_console() {
   refresh();
   resize_divs();
}

window.onresize = resize_divs;
