
function load_xml(s) {
   var xp = new ActiveXObject("Msxml2.DOMDocument.6.0");
   xp.setProperty("ProhibitDTD", false);
   xp.setProperty("ValidateOnParse", false);
   xp.setProperty("ResolveExternals", false);
   xp.setProperty("SelectionLanguage", "XPath");
   xp.loadXML(s);
   if (xp.parseError && xp.parseError.errorCode != 0)
      alert(xp.parseError.line + "/" + xp.parseError.linepos + ": " + xp.parseError.reason);
}

var freeze = false;
var resize = false;

function toggle_freeze() {
   freeze = !freeze;
   if (!freeze) {
      $('#continue_button').hide();
      $('#freeze_button').show();
      refresh();
   }  else {
      $('#freeze_button').hide();
      $('#continue_button').show();
   }
}

var prio_text = ["", "lowest", "low", "default", "high", "higher", ""];

function get_new_prio(prio, adv) {
   for (var i=0; i < prio_text.length; ++i) {
      if (prio_text[i] == prio) return prio_text[i + adv];
   }
   return "";
}

function get_prio_class(id) {
   var el = $("#" + id);
   var e = el.find(".co_entry span")[1];
   return { cls: $(e).text().replace(/\*$/, ""), e: e };
}
function prioritize_cons(prog, prot, prio) {
   var cmd = 'prioritize pair "' + prog + '" ' + prot + ' ' + prio;
   if (cFos_object) cFos_object.spd_command("@" + cmd);
   else $.ajax({ dataType: "text", async: false, url: "/cfosspeed/spd?" + encodeURIComponent(cmd) });
}

function adjust_class(el, c) {
   $(el).text(c).css("font-weight", c.charAt(c.length-1) == '*' ? "bold" : "normal");
}

function cup(prog, prot, id) {
   var o = get_prio_class(id);
   var prio = get_new_prio(o.cls, 1);
   if (!prio) return;
   prioritize_cons(prog, prot, prio);
   adjust_class(o.e, prio + '*');
}
function cdn(prog, prot, id) {
   var o = get_prio_class(id);
   var prio = get_new_prio(o.cls, -1);
   if (!prio) return;
   prioritize_cons(prog, prot, prio);
   adjust_class(o.e, prio + '*');
}
function coff(prog, prot, id) {
   prioritize_cons(prog, prot, "none");
   var o = get_prio_class(id);
   adjust_class(o.e, $(o.e).text().replace(/\*$/, ""));
}

function make_id(s) {
   var id = "";
   for (var i=0; i < s.length; ++i) {
      var h = s.charCodeAt(i).toString(16);
      while (h.length < 4) h = '0' + h;
      id += h;
   }
   return "x" + id;
}

function adjust_entry(el, o, f) {
   var d = el.find(".co_entry");
   var e = el.find(".co_entry span");
   var i = el.find(".co_entry .arrow");
   var spd = el.attr("data-spd");
   var a = o.c.replace(/\*$/, "");
   $(i).attr('src', 'images/prio_arrow_'+ a + '.png');
   $(e[0]).text(o.n > 1 ? o.n + '\u00d7' : '');
   adjust_class(e[1], o.c);
   $(e[2]).text(o.s + '%');
	 if (f) d.width(Math.ceil(d.width()/40) * 40);
   while (el.width()-d.width()-150 <  el.find(".co_hbar_cont").width()) {
   el.find(".co_hbar_cont .co_hbar:last-child").remove();
   }
   var h = Math.ceil(0.4 * o.s);
   var m = 40 - h;
   var c = $('<div class="co_hbar" style="margin-top: ' + m + 'px; height:' + h + 'px"></div>');
   el.find(".co_hbar_cont").prepend(c);

}

function refresh() {
   if (freeze) return;
   var c;
   var is_hta = false;
   if (cFos_object) {
      var js = cFos_object.current_connections(0);
      c = JSON.parse(js);
      is_hta = true;
   }
   else $.ajax({ dataType: "json", async: false, url: "/cfosspeed/stats/current_connections", success: function(d) { c = d; }});
   if (c.length > 0 && c[c.length-1] == null) c.splice(c.length-1, 1);
//c = [ { p: "chrome", t: "HTTP", c: "high", s: 100, n: 1 }];

   c.sort(function(a, b) {
      return Number(b.s) - Number(a.s);   
   });

   var in_use = { };
   for (i=0; i < c.length; ++i) {
      var o = c[i];
      var id = make_id(o.p + "|" + o.t);
      in_use[id] = true;
      var el = $("#" + id);
      if (el.length == 0) {
         var a = "('" + o.p + "','" + o.t + "','" + id + "')";
         var s = '<div id="' + id + '" style="clear: both; display: none"><img src="images/co_minus.png" onmouseover="this.src=\'images/co_minus_h.png\'" onmouseout="this.src=\'images/co_minus.png\'" class="co_button" onclick="cdn' + a + '"/>';
         icon_src = is_hta ? "images/program_icon.png" : "/cfosspeed/stats/icon?exe=" + encodeURIComponent(o.p);
         s += '<div class="co_entry"><img  style="float: left; margin-right: 4px" src="' + icon_src + '" width="32" height="32" alt="" /><span></span>' + o.p + ' (' + o.t + ')<br/><img src="images/prio_arrow_3.png" height="8" width="8" class="arrow" style="margin-right: 2px" /><span style="font-size: 10px" onclick="coff' + a + '"></span>/<span style="font-size: 10px"></span></div>';
         s += '<img src="images/co_plus.png" onmouseover="this.src=\'images/co_plus_h.png\'" onmouseout="this.src=\'images/co_plus.png\'" class="co_button" onclick="cup' + a + '"/>';
         s += '<div class="co_hbar_cont" style="float: left">'
//         for (var j=0; j < 10; ++j) s += '<div class="co_hbar" style="margin-top: 20px; height: 0px"></div>';
         s += '</div></div>';
         s += '';
//load_xml(s); //!!!
         var h = $(s);
         $("#co_box").append(h);
         h.fadeIn('fast');
         adjust_entry(h, o, true);
      }
      else chg = adjust_entry(el, o, false);
   }
   $("#co_box").children().each(function(i) {
      var el = $(this);
      if (!(el.attr('id') in in_use)) {
         el.fadeOut('fast', function() { $(this).remove(); });
      }
   });
   resize = false;
   setTimeout("refresh()", 1000);
}

function resize_divs() {
   resize = true;
   $('#co_box').width($(window).width() - 4);
   $('#co_box').height($(window).height() - $('#pageheader').height() - 20);

}

function init_console() {
   ini_file.set("global.ini", "All", "last_console_dialog", "simple");
   resize_divs();
   refresh();
}

window.onresize = resize_divs;
