
var ini_name = "user.ini";
var def_ini_name = "settings.ini";
var other_name = "Other";

var g_nStartIndex_Voip = 0;
var g_nStartIndex_MultiMedia = 0;
var g_nStartIndex_Game = 0;
var g_nStartIndex_FileShare = 0;
var g_bStartUp = false;
var g_bStartDown = false;
var g_nMaxCount = 9;

var turbo_map = {};

function push(a, e) { a[a.length] = e; }
var filter_trans = new Array();

function translation(e, t) { this.e = e; this.t = t; }

function init_filter_translation() {
   var ml = new ml_object();
   push(filter_trans, new translation("Games", ml.games));
   push(filter_trans, new translation("File Sharing", ml.p2p));
   //push(filter_trans, new translation("p2p", ml.p2p));
   push(filter_trans, new translation("Voice over IP", ml.voip));
   push(filter_trans, new translation("Multimedia", ml.multimedia));
   //push(filter_trans, new translation("Remote Control", ml.remote_control));
   //push(filter_trans, new translation("Other", ml.other));
   //push(filter_trans, new translation("clients", ml.client_prots));
   //push(filter_trans, new translation("servers", ml.server_prots));
   //push(filter_trans, new translation("special", ml.special));
}

function translate_filter(name) {
   for (var i = 0; i < filter_trans.length; ++i) {
      if (filter_trans[i].e.toLowerCase() == name.toLowerCase()) return filter_trans[i].t;
   }
   return name;
}

function prio_obj(filter, desc, prio, i) {
   this.filter = filter;
   this.desc = desc;
   this.prio = prio;
   this.ini = i;
}

var filters = new Object();
var prio_items = new Object();
var deleted_settings_ini_prio_items = new Object();

var current_filter;

function set_prio(key, idx, val, pname) {
   if (val != 0) {
      if (prio_items[key].prio != val) {
         prio_items[key].ini = ini_name;   // save in user.ini
         g_bNoChange = true;
      }
      prio_items[key].prio = val;
      get_element("pname" + idx).innerHTML = pname;

      save_prio_settings();
   }
   else {
      var n_count = 0;
      for (var x in prio_items) {
         if (prio_items[x].filter != current_filter) continue;
         else n_count++;
      }

      if (n_count == 1) {
         return;
      }
      else if (current_filter == "Voice over IP") {
         if (n_count - g_nStartIndex_Voip <= g_nMaxCount)
            g_nStartIndex_Voip = n_count - (g_nMaxCount + 1);
         if (g_nStartIndex_Voip < 0)
            g_nStartIndex_Voip = 0;
      }
      else if (current_filter == "Multimedia") {
         if (n_count - g_nStartIndex_MultiMedia <= g_nMaxCount)
            g_nStartIndex_MultiMedia = n_count - (g_nMaxCount + 1);
         if (g_nStartIndex_MultiMedia < 0)
            g_nStartIndex_MultiMedia = 0;
      }
      else if (current_filter == "Games") {
         if (n_count - g_nStartIndex_Game <= g_nMaxCount)
            g_nStartIndex_Game = n_count - (g_nMaxCount + 1);
         if (g_nStartIndex_Game < 0)
            g_nStartIndex_Game = 0;
      }
      else if (current_filter == "File Sharing") {
         if (n_count - g_nStartIndex_FileShare <= g_nMaxCount)
            g_nStartIndex_FileShare = n_count - (g_nMaxCount + 1);
         if (g_nStartIndex_FileShare < 0)
            g_nStartIndex_FileShare = 0;
      }

      g_bNoChange = true;
      deleted_settings_ini_prio_items[key] = true;
      delete prio_items[key];
      delete_table_row(prio_table_id, idx - 1);
      load_table();
      save_prio_settings();

   }
}

function read_section(iname, sec_name, prio) {
   ini.open(iname, sec_name);
   var cnt = ini.length;
   for (var i = 0; i < cnt; ++i) {
      var key = ini.key(i);
      var val = ini.value(key);
      var m = val.match(/\s*([\w\s]*)\s*,\s*(.*)\s*/);
      var filter = "", desc = "";
      if (m != null) {
         filter = m[1];
         desc = m[2];
      }
      //if (filter.length == 0) filter = other_name;
      filters[filter] = true;
      prio_items[key] = new prio_obj(filter, desc, prio, iname);
   }
}

function save_section(name, prio) {
   ini.open(ini_name, name);
   ini.delete_section();
   for (var x in prio_items)
      if (prio_items[x].prio == prio && prio_items[x].ini == ini_name) ini.value(x) = prio_items[x].filter + ", " + prio_items[x].desc;
}

function save_prio_settings() {
   save_section(prio5_section, 5);
   save_section(prio4_section, 4);
   save_section(prio3_section, 3);
   save_section(prio2_section, 2);
   save_section(prio1_section, 1);
   for (var x in deleted_settings_ini_prio_items) {
      if (prio_items[x] == null) {
         ini.del(def_ini_name, prio5_section, x);
         ini.del(def_ini_name, prio4_section, x);
         ini.del(def_ini_name, prio3_section, x);
         ini.del(def_ini_name, prio2_section, x);
         ini.del(def_ini_name, prio1_section, x);
      }
   }
}

function save_turbo_settings() {
   ini.open(ini_name, "turbo_section");
   ini.delete_section();
   for (var x in turbo_map)
      ini.value(x) = true;
}

function read_turbo_settings() {
   ini.open(ini_name, "turbo_section");
   var cnt = ini.length;
   for (var i = 0; i < cnt; ++i) {
      var key = ini.key(i);
      turbo_map[key] = true;
      //var TempArray1 = new Array();
      //var TempArray1 = key.split("(");	
      //key=TempArray1[1];	  
      //var TempArray2 = new Array();	  
      //var TempArray2 = key.split(")");
      //key=TempArray2[0];
      set_program_priority(key, "higher");
   }
}

function exit_dialog(save) {
   if (save) {
      save_settings();
      ini.flush();
      cFos_object.action("spd reload");
   }
}

function load_table() {
   var a = new Array();
   var nCurrentIndex = 0;

   read_section(ini_name, prio5_section, 5);
   read_section(ini_name, prio4_section, 4);
   read_section(ini_name, prio3_section, 3);
   read_section(ini_name, prio2_section, 2);
   read_section(ini_name, prio1_section, 1);

   read_used_programs();
   ini.open("global.ini", "All");
   var all = Number(ini.value("show_all_programs"));
   if (Boolean(all))
      show_all_programs = true;
   else
      show_all_programs = false;

   for (var x in prio_items) {
      if (prio_items[x].filter != current_filter) continue;

      if (current_filter == "Voice over IP" && nCurrentIndex < g_nStartIndex_Voip) {
         nCurrentIndex++;
         continue;
      }
      else if (current_filter == "Multimedia" && nCurrentIndex < g_nStartIndex_MultiMedia) {
         nCurrentIndex++;
         continue;
      }
      else if (current_filter == "Games" && nCurrentIndex < g_nStartIndex_Game) {
         nCurrentIndex++;
         continue;
      }
      else if (current_filter == "File Sharing" && nCurrentIndex < g_nStartIndex_FileShare) {
         nCurrentIndex++;
         continue;
      }
      else
         nCurrentIndex++;

      var o = new Object();
      if (prio_items[x].desc.length != 0) {
         if (show_prio_id) o.name = prio_items[x].desc + " (" + x + ")";
         else o.name = prio_items[x].desc;
      }
      else
         o.name = x;

      var add = true;
      //if (("show_all_programs" in window) && !show_all_programs) {
      if (("show_all_programs" in window) && show_all_programs) {
         if (!(x in used_programs)) add = false;
      }
      if (add) {
         o.key = x;
         o.prio = prio_items[x].prio;
         o.className = (a.length & 1) != 0 ? "back1" : "back2";
         a[a.length] = o;
      }

      if (a.length >= g_nMaxCount) break;
   }
   //fill_table(prio_table_id, 0, a);
   fill_table(prio_table_id, 0, a, g_nMaxCount);

   var is_b = get_element("b1") != null;
   var len = a.length;
   for (var i = 0; i < len; ++i) {
      init_radio_button("r" + (i + 1), a[i].prio, true);
      if (is_b) init_pushbutton("b" + (i + 1));
      init_turbo_button("turbo_img" + (i + 1), a[i].name);
   }

   if (show_all_programs)
      window.setTimeout("load_table()", 5000);
}

function set_filter(filter) {
   var reload = current_filter != filter;
   current_filter = filter;

   cFos_object.param(filter_key) = current_filter;
   if (reload) load_table();
}

function BeginScrollDown() {
   g_bStartDown = true;
}

function BeginScrollUp() {
   g_bStartUp = true;
}

function EndScroll() {
   g_bStartUp = false;
   g_bStartDown = false;
}

function ScrollDownLoad() {
   if (g_bStartDown == false) return;

   var n_count = 0;
   for (var x in prio_items) {
      if (prio_items[x].filter != current_filter) continue;
      else n_count++;
   }

   if (current_filter == "Voice over IP") {
      if (n_count - g_nStartIndex_Voip > g_nMaxCount) {
         g_nStartIndex_Voip += g_nMaxCount;
         if (n_count - g_nStartIndex_Voip < g_nMaxCount)
            g_nStartIndex_Voip = n_count - g_nMaxCount;
      }
      else
         return;

   }
   else if (current_filter == "Multimedia") {
      if (n_count - g_nStartIndex_MultiMedia > g_nMaxCount) {
         g_nStartIndex_MultiMedia += g_nMaxCount;
         if (n_count - g_nStartIndex_MultiMedia < g_nMaxCount)
            g_nStartIndex_MultiMedia = n_count - g_nMaxCount;
      }
      else
         return;
   }
   else if (current_filter == "Games") {
      if (n_count - g_nStartIndex_Game > g_nMaxCount) {
         g_nStartIndex_Game += g_nMaxCount;
         if (n_count - g_nStartIndex_Game < g_nMaxCount)
            g_nStartIndex_Game = n_count - g_nMaxCount;
      }
      else
         return;
   }
   else if (current_filter == "File Sharing") {
      if (n_count - g_nStartIndex_FileShare > g_nMaxCount) {
         g_nStartIndex_FileShare += g_nMaxCount;
         if (n_count - g_nStartIndex_FileShare < g_nMaxCount)
            g_nStartIndex_FileShare = n_count - g_nMaxCount;
      }
      else
         return;
   }

   load_table();

   if (g_bStartDown == true)
      window.setTimeout("ScrollDownLoad()", 200);
}

function ScrollUpLoad() {
   if (g_bStartUp == false) return;

   var n_count = 0;
   for (var x in prio_items) {
      if (prio_items[x].filter != current_filter) continue;
      else n_count++;
   }

   if (current_filter == "Voice over IP") {
      if (g_nStartIndex_Voip > 0) {
         g_nStartIndex_Voip -= g_nMaxCount;
         if (g_nStartIndex_Voip < 0)
            g_nStartIndex_Voip = 0;
      }
      else
         return;
   }
   else if (current_filter == "Multimedia") {
      if (g_nStartIndex_MultiMedia > 0) {
         g_nStartIndex_MultiMedia -= g_nMaxCount;
         if (g_nStartIndex_MultiMedia < 0)
            g_nStartIndex_MultiMedia = 0;
      }
      else
         return;
   }
   else if (current_filter == "Games") {
      if (g_nStartIndex_Game > 0) {
         g_nStartIndex_Game -= g_nMaxCount;
         if (g_nStartIndex_Game < 0)
            g_nStartIndex_Game = 0;
      }
      else
         return;
   }
   else if (current_filter == "File Sharing") {
      if (g_nStartIndex_FileShare > 0) {
         g_nStartIndex_FileShare -= g_nMaxCount;
         if (g_nStartIndex_FileShare < 0)
            gg_nStartIndex_FileShare = 0;
      }
      else
         return;
   }

   load_table();

   if (g_bStartUp == true)
      window.setTimeout("ScrollUpLoad()", 200);
}

function Exec_OSD() {
   var param = Traffic_Shaping_Settings.commandLine.match(/[\w!#$%&'*+-/=?^_`{}~\\:]+|\"[^\"]*\"/g);
   for (var i = 0; i < param.length; ++i) {
      if (param[i].charAt(0) == '"') param[i] = param[i].substr(1, param[i].length - 2);
   }
   homedir = param[0].substr(0, param[0].lastIndexOf('\\') + 1);

   var sh = new ActiveXObject("Shell.Application");
   sh.ShellExecute(homedir + "GFOSD.exe");
}

function Game_MaxPriority() {
   for (var x in prio_items) {
      if (prio_items[x].filter != "Games")
         prio_items[x].prio = 1;
      else
         prio_items[x].prio = 5;

      prio_items[x].ini = ini_name;
   }

   g_bNoChange = true;
   load_table();

   Exec_OSD();
}

function ChangeColor(index) {
   if (index == 2) {
      get_element("Layer5").style.color = '#DEDEDE';
      get_element("Layer2").style.color = '#70E2FF';
      get_element("Layer3").style.color = '#DEDEDE';
      get_element("Layer4").style.color = '#DEDEDE';
      get_element("Layer1").style.color = '#DEDEDE';
   }
   else if (index == 3) {
      get_element("Layer5").style.color = '#DEDEDE';
      get_element("Layer2").style.color = '#DEDEDE';
      get_element("Layer3").style.color = '#70E2FF';
      get_element("Layer4").style.color = '#DEDEDE';
      get_element("Layer1").style.color = '#DEDEDE';
   }
   else if (index == 4) {
      get_element("Layer5").style.color = '#DEDEDE';
      get_element("Layer2").style.color = '#DEDEDE';
      get_element("Layer3").style.color = '#DEDEDE';
      get_element("Layer4").style.color = '#70E2FF';
      get_element("Layer1").style.color = '#DEDEDE';
   }
   else if (index == 1) {
      get_element("Layer5").style.color = '#70E2FF';
      get_element("Layer2").style.color = '#DEDEDE';
      get_element("Layer3").style.color = '#DEDEDE';
      get_element("Layer4").style.color = '#DEDEDE';
      get_element("Layer1").style.color = '#DEDEDE';
   }
   else if (index == 5) {
      get_element("Layer5").style.color = '#DEDEDE';
      get_element("Layer2").style.color = '#DEDEDE';
      get_element("Layer3").style.color = '#DEDEDE';
      get_element("Layer4").style.color = '#DEDEDE';
      get_element("Layer1").style.color = '#70E2FF';
   }
}

function set_program_turbo(process, idx) {
   var img = document.getElementById("turbo_img" + idx);
   if (process in turbo_map) {
      if (prio_items.hasOwnProperty(process)) {
         switch (prio_items[process].prio) {
            case 1:
               prio = "lowest";
               break;
            case 2:
               prio = "low";
               break;
            case 3:
               prio = "default";
               break;
            case 4:
               prio = "high";
               break;
            case 5:
               prio = "higher";
               break;
            default:
               prio = "default";
         }
      } else {
         prio = "default";
      }
      delete turbo_map[process];
      img.src = "asus/images/slider/turbo_icon_n.png";
   } else {
      turbo_map[process] = true;
      img.src = "asus/images/slider/turbo_icon_d.png";
      prio = "higher";
   }
   save_turbo_settings();
   set_program_priority(process, prio);
}

function set_program_priority(process, prio) {
   var http = new XMLHttpRequest();
   var cmd = 'prioritize prog "' + process + '" ' + prio;
   var url = "http://localhost:1487/cfosspeed/spd?" + encodeURIComponent(cmd);
   http.open("GET", url);
   http.send();
}



