
function slot_cmd(cmd) {
   var r = jQuery.trim(spd_command("@slot " + slot + " " + cmd));
   return r;
}

function set_name() {
   slot_cmd("set name " + $("#n")[0].value);
}

function slot_mode() {
   var m = $("#slot_mode")[0].value;
   slot_cmd("set mode " + m);
   if (m.indexOf("nettalk") == 0 || m.indexOf("total") == 0) $("#chkboxes").hide();
   else $("#chkboxes").show();
}

var slot_color = [0, "#c00000", "#c0c000", "#00c0c0", "#2780dc", "#0300c0", "#923be4", "#c000c0", "#ff8200", "#26c000", "#999999"];

function update() {
   $("#n")[0].value = slot_cmd("get name");
   $(".slot_num").text(slot);
   $(".colorbox").css("background-color", slot_color[slot]);
   var m = $("li.sub");
   m.removeClass("active");
   $(m[slot-1]).addClass("active");

   var m = slot_cmd("get mode");
   var o = $("#slot_mode option").removeAttr("selected");
   for (var i=0; i < o.length; ++i) {
      if (o[i].value == m) {
         $(o[i]).attr("selected", "selected");
         break;
      }
   }
   $(".setting img").attr("src", "images/checkbox_off.png");
   if (m.indexOf("nettalk") == 0 || m.indexOf("total") == 0) $("#chkboxes").hide();
   else $("#chkboxes").show();
   if (slot_cmd("get protocols") == '*') $("#o").attr("src", "images/checkbox_on.png");
   var c = slot_cmd("get categories").split(':');
   function in_array(c, t) {
      for (var i=0; i < c.length; ++i) if (c[i] == t) return true;
      return false;
   }
   $(".setting img").each(function(i) {
      if (this.id == "o") return true;
      var a = this.id.split(':');
      var found = true;
      for (var i=0; i < a.length; ++i) if (!in_array(c, a[i])) { found = false; break; }
      if (found) this.src = "images/checkbox_on.png";
   });
}

function switch_slot(num) {
   slot = num;
   update();
}

function resize_divs() {
   var win_height = $(window).height();
   $('#menu').height(win_height);
   $('#dlg').height(win_height);
}

function dialog() {
   $(".setting").on("click", function(e) {
      var el = e.target;
      if (el.tagName.toLowerCase() != "img") return true;
      el.src = el.src.indexOf("checkbox_on") != -1 ? "images/checkbox_off.png" : "images/checkbox_on.png";
      var c = [ ];
      $(".setting img").each(function(i) {
         if (this.id != "o" && this.src.indexOf("checkbox_on") != -1) c.push(this.id);
      });
      slot_cmd("set categories " + c.join(':'));
      if ($("#o").attr("src").indexOf("checkbox_on") != -1) slot_cmd("set protocols *");
   });
   $('h2').wrapInner('<span class="h2_text"></span>');
   resize_divs();
   update();
}

window.onresize = resize_divs;
