
function resize_divs() {
   resize = true;
   $('#ping_box').width($(window).width() - 42);
   $('#ping_box').height($(window).height() - ( $('#pageheader').height() + $('#pagefooter').height() + 70) );
   ping_stats();
}

function digits(v, d) {
   var s = String(v);
   while (s.length < d) s = '0' + s;
   return s;
}

var can, ctx;

function point(x, y) {
   var sz = 1.5;
   ctx.beginPath();
   ctx.moveTo(x-sz, y-sz);
   ctx.lineTo(x+sz, y+sz);
   ctx.moveTo(x+sz, y-sz);
   ctx.lineTo(x-sz, y+sz);
   ctx.stroke();
}

function plot() {
   var res = spd_command("@ping_hist");
   if (res == "") return;
   var a = res.split(',');
   var mx = 1, mn = 1000000, sum = 0, cnt = 0;
   for (var i=0; i < a.length; ++i) {
      var v = Number(a[i]);
      if (v == 0) continue;
      if (mx < v) mx = v;
      if (mn > v) mn = v;
      sum += v;
      ++cnt;
   }
   var avg = Math.round(sum / cnt * 10) / 10;
   $("#stat").html("min: <b style='color: #404080'>" + mn + "</b> msec | avg: <b style='color: #404080'>" + avg + "</b> msec | max: <b style='color: #404080'>" + mx + "</b> msec");
   var av = Math.round(2 * avg);
   mx = av > mx ? av : mx;
   $("#mx").text(mx + " msec");
   var tm = Math.round(1.048576 * a.length);
   $("#tm").text(Math.floor(tm / 60) + ":" + digits(tm % 60, 2) + " min ago");

   ctx.clearRect(0, 0, can.width, can.height);
   for (var i=0; i < a.length; ++i) {
      var v = a[a.length - i - 1]
      if (v == 0) continue;
      var x = (i + 0.5) / a.length * can.width;
      var y = v / mx * can.height;
      point(x, can.height - y);
   }
}

function ping_stats() {
   var p = $("#ps");
   can = p[0];
   can.width = p.parent().width()-2;
   can.height = p.parent().height()-2;
   ctx = can.getContext("2d");
   ctx.strokeStyle = '#0000ff'
//   ctx.fillStyle = "#FF0000";
//   ctx.fillRect(0,0,150,75);
   window.setInterval("plot()", 750);
}

function init() {
    resize_divs();
    ping_stats();
    window.onresize = resize_divs;
}

