﻿
var tabs = [];

function make_tabs(s) {
  var _lines = s.split('\n');
  var a = { title: "", sections: [] };
  var lines = [];
  for (var i=0; i < _lines.length; ++i) {
     var ln = jQuery.trim(_lines[i]);
     if (ln.length > 0) lines.push(ln);
  }
  var sec_title = "";
  var sec = null;
  for (var i=0; i < lines.length; ++i) {
     if (a.title == "") {
        a.title = lines[i];
        a.sections = [];
        continue;
     }
     if (lines[i].indexOf('=') == -1) {
        if (sec != null) {
          a.sections.push(sec);
          sec = null;
          sec_title = "";
        }
        tabs.push(a);
        a = { title: lines[i], sections: [] };
        continue;
     }
     var m = lines[i].split(':');
     if (m[0] != sec_title) {
        if (sec != null) a.sections.push(sec);
        sec = { title: m[0], keys: [], vals: [] };
        sec_title = m[0];
     }
     if (m.length > 2) {
        for (var j=2; j < m.length; ++j) m[1] += ":" + m[j];
        m = m.slice(0, 2);
     }
     if (m[1]) {
        var kv = m[1].split('=');
        sec.keys.push(kv[0]);
        sec.vals.push(kv[1]);
     }
  }
  if (sec != null) a.sections.push(sec);
  tabs.push(a);
}

function esc_text(text) {
  text = String(text);
  return text.replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;").
     replace(/&(?!gt;|lt;|quot;|apos;|amp;)/g, "&amp;");
}

var difference = 24;
var minimum_width = 0;
function setMinimumWidth() {
  var bar_size = 0;
  for (var t=0; t < tabs.length; ++t)
    bar_size += $('#tab_'+t).width() + 10;

  minimum_width = bar_size + difference;
}

function tabSelect(id) {
  if (tabs[id]) {
    $('.tab_a').removeClass('tab_a').addClass('tab');
    $('#tab_'+id).removeClass('tab').addClass('tab_a');
    $('.tab_a').removeClass('hover');
    $('.tab_box').hide();
    $('#tab_box_'+id).show();
    if (tabs[id].title.indexOf("WLAN") != -1) $('#wlan_info').show(); else $('#wlan_info').hide();
  }
}

function tableToggle(id) {
  if ($('#el_'+id).css('display') == "block") {
    $('#el_'+id).css('display', 'none');
    $('#tb_'+id).attr('src', 'images/close_n.png');
    $('#tb_'+id).hover(function() {$(this).attr('src', 'images/close_h.png');}, function() {$(this).attr('src', 'images/close_n.png');})
  } else {
    $('#el_'+id).css('display', 'block');
    $('#tb_'+id).attr('src', 'images/open_n.png');
    $('#tb_'+id).hover(function() {$(this).attr('src', 'images/open_h.png');}, function() {$(this).attr('src', 'images/open_n.png');})
  }
}

function tabs_to_html() {
  var s = "";
  for (var t=0; t < tabs.length; ++t) {
     s += '<div class="tab" id="tab_' + t + '" onclick="tabSelect(' + t + ');">' + tabs[t].title + '</div>';
  }
  $("#tabs").html(s);
  s = "";
  for (var t=0; t < tabs.length; ++t) {
    s += '<div class="tab_box" id="tab_box_' + t + '" style="display: block; overflow: auto;">\n';
     for (var si=0; si < tabs[t].sections.length; ++si) {
        var sec = tabs[t].sections[si];
        s += '<h2 style="margin: 4px 0px;">' + sec.title + '</h2>\n';

        s += '<table id="el_'+t+'_'+si+'" class="section"><tbody>\n';
        for (var k=0; k < sec.keys.length; ++k) {
           s += '<tr><td class="key">' + esc_text(sec.keys[k]) + '</td><td class="val">' + esc_text(sec.vals[k]) + '</td></tr>\n';
        }
        s += '</tbody></table>\n';
        s += '</div>\n';
     }
     s += '</div>\n';
  }
  $("#info").html(s);
}

function resize_divs() {
   var win_height = $(window).height();
   $('#menu').height(win_height);
   $('#dlg').height(win_height);
}

function init() {
  if(!cFos_object) return false;

  var is_wlan = false;
  var is_adapter = false;
  var s = cFos_object.spd_command("@speed_info");
  if (s.length > 0) is_adapter = true;
  var s2 = cFos_object.spd_command("@adapter_info");
  if (s2.length > 0) {
     is_adapter = true;
     s += "\n" + s2;
  }
  var w = jQuery.trim(cFos_object.query_info("wlan_info"));
  if (w.length > 0) {
     is_wlan = true;
     s += w;
  }

  if (is_wlan || is_adapter) {
    s = s.replace(/\0/g, "\\0");
//    do_resize();
    make_tabs(s);
    tabs_to_html();
    if (is_wlan) {
      s = cFos_object.query_info("wlan_channel_recommendation");
      s = jQuery.trim(s);
      if (s == "999") s = ml_object.wlan_no_service;
      else if (s == "0") s = ml_object.wlan_no_station;
      s = s.replace(/\n/g, "<br />");
      $("#channels").html(s);
    }
  } else {
    $('#tabs').hide();
    $('#info').hide();
    $("#wlan_info").replaceWith('<h1 style="margin-left: 30px; color: #ff0000">' + ml_object.no_adapter + '</h1>');
  }
  resize_divs();
  $('h2').wrapInner('<span class="h2_text"></span>');
  if ($('#tab_0')) tabSelect('0');
  return true;
}

window.onresize = resize_divs;
