#!/usr/bin/perl
use strict;
use warnings;


sub check_tines_hq_connection {
    check_exists_command("ping") or return;

    my $check = system("ping -c 1 hq.tines.io  > /dev/null 2>&1");

    if ($check == 0) {
        print("Connection to Tines HQ successful - your installation will be able to send telemetry data if enabled.\n");
    } else {
        print("Connection to Tines HQ failed - your installation will not be able to send telemetry data.\n");
    }
}

sub check_exists_command {
    my $check = `sh -c 'command -v $_[0]'`;

    return $check;
}

sub check_required_commands {
    my @commands= ("docker" , "docker-compose");

    foreach my $command (@commands) {
        print("checking $command \n");
        check_exists_command($command) or die "$0 requires $command";
    }
}

sub check_docker_deamon {
  system("docker info > /dev/null 2>&1") == 0 or die "Checks failed: Docker daemon does not appear to be running";
}

sub check_containers {
    my $list = `docker-compose ps --services`;

    if ($? == 0) {
      print("List of containers: $list \n")
    }
}

check_tines_hq_connection;
check_required_commands;
check_docker_deamon;
check_containers;
