#!/bin/bash

print_message() {
  printf "•  %s\n" "$1"
}

print_success_message() {
  printf "\r☑️  %s\n" "$1"
}

print_error_message() {
  printf "❌  %s\n" "$1"
}

print_heading() {
  local input="$1"
  echo -e "\n###########################"
  echo "# $input"
  echo -e "###########################\n"
}

resolve_docker_compose_command() {
  if docker compose version &> /dev/null; then
    docker_compose="docker compose"
  else
    docker_compose="docker-compose"
  fi

  if [[ "${USE_OLD_DOCKER_COMPOSE_SHELL_COMMAND:-false}" == "true" ]]; then
    print_message "Using docker-compose as shell command"
    docker_compose="docker-compose"
  fi
}

append_to_result_log() {
  local section="$1"
  local key="$2"
  local value="$3"

  echo "$section: $key: $value" >> /opt/tines/troubleshoot/result.log
}
