#!/bin/bash

# Get the directory of the current script.
script_dir=$(dirname "$0")

# Change working directory to the script's directory.
cd "$script_dir" || exit
# shellcheck source=/dev/null
source "$script_dir/.common.sh"

resolve_docker_compose_command

# Check if HQ is reachable using curl.

url="https://hq.tines.io/version"
response_code=$(curl -sL -w "%{http_code}" -o /dev/null "$url")
if [ "$response_code" -eq 200 ]; then
  print_success_message "The URL $url is reachable from the host (HTTP status code: $response_code)."
  append_to_result_log "hq" "connect_from_host" true
else
  print_error_message "Failed to reach the URL $url from the host (HTTP status code: $response_code)." >> errors.log
  print_message "Please check your internet connection."
  append_to_result_log "hq" "connect_from_host" false
fi

# Check if HQ is reachable from the container.

output=$($docker_compose run --rm tines-app bash -c "
url=\"https://hq.tines.io/version\"
response_code=\$(curl -sL -w \"%{http_code}\" -o /dev/null \"\$url\")

if [ \"\$response_code\" -eq 200 ]; then
  echo -e \"\r☑️  The URL \$url is reachable from the container (HTTP status code: \$response_code).\n\"
else
  echo -e \"❌  Failed to reach the URL \$url from the container (HTTP status code: \$response_code).\n\"
  echo -e \"•  Please check your internet connection.\n\"
fi
")

if [ $? -eq 0 ]; then
  print_message "$output"
  append_to_result_log "hq" "connect_from_container" true
else
  print_error_message "$output" >> errors.log
  append_to_result_log "hq" "connect_from_container" false
fi
