#!/bin/bash

if [ -z "$RUNNING_IN_CONTAINER" ]; then
  # Get the directory of the current script.
  script_dir=$(dirname "$0")

  # Change working directory to the script's directory.
  cd "$script_dir" || exit
  # shellcheck source=/dev/null
  source "$script_dir/.common.sh"

  resolve_docker_compose_command

  # Run the script in the temporary tines-app container and mount volume containing the diagnostic result logs.
  $docker_compose run --volume "/opt/tines/":/tmp --rm tines-app bash -c "RUNNING_IN_CONTAINER=1 /tmp/troubleshoot/send-results-to-support.sh"
else
  result_log_file="/tmp/troubleshoot/result.log"
  env_var_errors_log_file="/tmp/troubleshoot/env-var-errors.log"

  # Verify the result logs exist and exit if missing.
  if [ ! -f "$result_log_file" ]; then
    echo "result.log file does not exist."
    exit 1
  fi

  if [ ! -f "$env_var_errors_log_file" ]; then
    echo "env-var-errors.log file does not exist."
    exit 1
  fi

  # Execute rake task to create JSON and forward to CSE webhook.
  bundle exec rake tines:send_self_hosted_diagnostics_report --trace
fi
